@extends('layouts.master')

@section('title')
    تقرير الحضور والغياب للدورة التدريبية
@endsection

@section('first-css')
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/charts.css/dist/charts.min.css">
    <style>
        #my-chart.column {
            height: 200px;
            /* max-width: 500px; */
            margin: 0 auto;
        }
    </style>
@endsection

@section('content-body')
    <!--**********************************
                                    Content body start
                                ***********************************-->
    @include('massages')
@section('route-path')
    <div class="container-fluid container-fluid-traning px-0">
        <div class="d-flex flex-wrap align-items-end justify-content-between  mb-3">
            <h3>
                تقرير الحضور والغياب للدورة التدريبية {{ $rooms[0]->room->name }} {{ $rooms[0]->room->course->title }}
            </h3>
            <div class="link">
                <a href="" class="px-4 ">عرض تقرير الحضور والغياب
                </a>
            </div>
        </div>
    </div>
@endsection
<!-- row -->
<div class="container-fluid container-fluid-traning bg-white">
    <!--**********************************Tabs Start***********************************-->
    <div class="d-flex flex-wrap align-items-start justify-content-start  mb-3">
        <a href="{{ route('export_attendance', $rooms[0]->room_id) }}" class="btn btn-primary  me-1">
            <i class="mdi mdi-plus-circle ms-2"></i>تصدير الى ملف اكسل
        </a>

    </div>
    <!--**********************************Tabs End***********************************-->
    <div class="row">
        <div class="col-xl-12 tab-content">
            <!--**********************************Table AllTransaction Start***********************************-->

            <div class="tab-pane fade show active" id="AllTransaction" role="tabpanel"
                aria-labelledby="transaction-tab">
                <div class="table-responsive fs-14">
                    <table class="table card-table display mb-4 dataTablesCard text-black text-center" id="example">
                        <thead>
                            <tr>
                                <th>رقم </th>
                                <th>اسم المتدرب </th>
                                {{-- @foreach ($rooms as $room) --}}
                                @foreach ($rooms[0]->attendances as $lesson)
                                    @isset($lesson)
                                        <th>
                                            {{ $arrayDays[$lesson->created_at->format('D')] }}
                                        </th>
                                    @endisset
                                @endforeach
                                {{-- @endforeach --}}



                                <th>نسبة الحضور</th>
                                <th>نسبة الغياب</th>
                                <th>نسبة الدروس الغير منجزة</th>

                            </tr>
                        </thead>
                        <tbody>
                            @isset($rooms)
                                @foreach ($rooms as $room)
                                    <tr class="odd" role="row">
                                        <td>
                                            @isset($room)
                                                {{ $loop->iteration }}
                                            @endisset
                                        </td>
                                        <td>
                                            @isset($room->student->name)
                                                {{ $room->student->name }}
                                            @endisset
                                        </td>
                                        @foreach ($room->attendances as $attendance)
                                            @if ($attendance->is_present == 1)
                                                <td>&#10003;</td>
                                            @else
                                                <td>&#10007;</td>
                                            @endif
                                        @endforeach

                                        <td>
                                            @isset($room->presentsPercentage)
                                                {{ $room->presentsPercentage }}
                                            @else
                                                0
                                            @endisset
                                            %
                                        </td>
                                        <td>
                                            @isset($room->absentsPercentage)
                                                {{ $room->absentsPercentage }}
                                            @else
                                                0
                                            @endisset
                                            %
                                        </td>
                                        <td>
                                            @isset($room->notAttendantPercentage)
                                                {{ $room->notAttendantPercentage }}
                                            @else
                                                0
                                            @endisset
                                            %
                                        </td>

                                    </tr>
                                @endforeach
                            @endisset
                        </tbody>
                    </table>
                </div>
            </div>
            <!--**********************************Table AllTransaction End***********************************-->
        </div>
    </div>

</div>

<div class="container-fluid">
    <div class="row row-cols-1  justify-content-around">
        <div class="card text-white bg-white mb-3 col-10">
            <div class="card-body d-flex row">
                <div class="col-md-12 col-lg-5 col-xl-5 col-sm-12 d-flex flex-column justify-content-start">
                    <div class="d-flex justify-content-start align-items-center mb-2 mt-4">
                        <div class="color-pointer bg-excellent"></div>
                        <div class="text-dark fw-bold pe-2">نسبة الحضور <span class="text-success">
                                @isset($presentsAll)
                                    {{ $presentsAll }}
                                @endisset%
                            </span></div>
                    </div>
                    <div class="d-flex justify-content-start align-items-center mb-2">
                        <div></div>
                        <div class="color-pointer bg-v-good"></div>
                        <div class="text-dark fw-bold pe-2">نسبة الغياب <span class="text-success">
                                @isset($absentsAll)
                                    {{ $absentsAll }}
                                @endisset%
                            </span></div>
                    </div>
                    <div class="d-flex justify-content-start align-items-center mb-2">
                        <div></div>
                        <div class="color-pointer bg-good"></div>
                        <div class="text-dark fw-bold pe-2">نسبة الغير منجزة <span class="text-success">
                                @isset($notAttendantAll)
                                    {{ $notAttendantAll }}
                                @endisset%
                            </span></div>
                    </div>


                </div>
                <div class="col-md-12 col-lg-7 col-xl-7 col-sm-12">

                    <div
                        style="
                        width: 250px; height: 250px;
                        border-radius: 50%;
                        margin:auto;

                        background: conic-gradient(
                            #35537d 0deg {{ $presentsAllDeg }}deg,
                            #a31e23 {{ $presentsAllDeg }}deg {{ $presentsAllDeg + $absentsAllDeg }}deg,
                            #b37053 {{ $presentsAllDeg + $absentsAllDeg }}deg {{ $presentsAllDeg + $absentsAllDeg + $notAttendantAllDeg }}deg
                        );">
                    </div>
                    <h5 class="text-center text-primary mt-2">محتوى الدورة</h5>
                </div>
            </div>
        </div>


    </div>
</div>

<!--**********************************
                        Content body end
            ***********************************-->
@endsection
@section('script')
@endsection
